#define		NUM_CHANNELS		3
#define		NUM_CLUSTERS		1
#define		NUM_PRT_WEIGHT		24
float4		fv4PRTConst[NUM_CLUSTERS*(1+NUM_CHANNELS*(NUM_PRT_WEIGHT/4))];
float4		fv4PRTDiffColor = { 1.0f, 1.0f, 1.0f, 1.0f };    
float		fColorScaler=1.0f;

float4x4	matProj;				//macierz projekcji
float4x4	matWorld;				//macierz swiata
float4x4	matViewWorld;
float4x4	matWorldIT;				//macierz swiata odwrotna transponowana
float4x4	matInvProj;				//odwrotna macierz projekcji
float4x4	matReflect;				//macierz odbicia
float4x4	matViewToLightProj;		//macierz swiatla

float3		fvSpecularPosition;	
float4		fvSpecularColor;		//kolor swiatla
float4		fvDiffuseColor;			//kolor swiatla
float4		fvDiffuse1Color;		//kolor swiatla
float3		fvEyePosition;			//pozycja oka
float3		fvDiffusePosition;		//pozyca swiatla
float3		fvDiffuse1Position;		//pozyca swiatla 1
float3		fvDiffuse2Position;		//pozyca swiatla 2
float3		fvDiffuse3Position;		//pozyca swiatla 3

float		fSpecularPower=64;		//sila swiatla
float		fScreenWidth=640.f;
float		fScreenHeight=480.f;

float		fScrollY=480;
float		fMorphPhase=0.9;
float		fBlurScale;
float		fFarClamp=1.0;
float		fDFar=40+10;
float		fDFocus=28+10;
float		fDNear=10+10;
float		fExposure=1;
float		fReflect=0.05;//0.05;
float		fCubePow=0.55;//0.55;
float		fFresnelConst=0.03;
float2		fv2BlurOffsets[12] = 
{
   -0.326212, -0.405805,
   -0.840144, -0.073580,
   -0.695914,  0.457137,
   -0.203345,  0.620716,
    0.962340, -0.194983,
    0.473434, -0.480026,
    0.519456,  0.767022,
    0.185461, -0.893124,
    0.507431,  0.064425,
    0.896420,  0.412458,
   -0.321940, -0.932615,
   -0.791559, -0.597705,
};
static const int fBlurSize = 13;
static const float BlurWeights[fBlurSize] = 
{
    0.002216,
    0.008764,
    0.026995,
    0.064759,
    0.120985,
    0.176033,
    0.199471,
    0.176033,
    0.120985,
    0.064759,
    0.026995,
    0.008764,
    0.002216,
};

float		fBloomScale=1.0f;
float		fBlurFactor=0.4;
float		fBloomBlend=0.09f;
float		fAlphaTest=0;
bool		isFix=true;
float		fCrossFade=0;
float		fDiv=4;
float		fFader=0;
float		fSkyBoxScale=0;
float		fToneMappingGray=0.18f;
float		fToneMappingLuminace=0.18f;
float		fToneMappingWhiteCutoff=0.8f;
bool		isToneMapping=true;
bool		isDofTest=true;
float		fLuminance = 0.08f;
static const float fMiddleGray = 0.18f;
static const float fWhiteCutoff = 0.8f;
bool		isBloomMirror=false;
float3		fOffsetY = float3(0.31, 0.12, 0.52);
float3		fOffsetZ = float3(0.31, 0.5, 0.5);
float		fRefTime=0;
float4		fWaterColor=float4(0.0,0.1,0.4,1);
float		fTestX=0;
float		fTestY[16]={0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,};
float4		refScale=(0.1f,0.01f,0.01f,0.0f);
float		fTime=0;
float		fRefY=0;
float4		fvCameraPos;
bool		isPRTTex=true;//czy textura jest dostepna przy prt
bool		isPRTSpecular=true;//prt+specular
bool		isPRTCube=true;//czy jest odbicie srodowiska
bool		isMono=false;

//************************************************CIENIE
float fPixelSize=1.f/512.f;
float fShadowOffset=0.009;//0.0001;
float fShadowIntensity=0.25f;
float3 fv3PointLightPosition=(0,0,0);
float fInvLightRange=0.0007f;
//************************************************


texture		m_tex_diff_0;
texture		m_tex_nrm_0;
texture		m_tex_spec_0;
texture		m_shadow_mapp;
texture		m_shadow3D_mapp;
texture		m_reflect3D_mapp;

sampler texReflectCube=sampler_state
{
    Texture = <m_reflect3D_mapp>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
};

sampler texShadowCube=sampler_state
{
    Texture = <m_shadow3D_mapp>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
};

sampler2D tex_shadow_mapp=sampler_state
{
    Texture = <m_shadow_mapp>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
};

sampler2D tex_diff_0=sampler_state
{
    Texture = <m_tex_diff_0>;
    AddressU = Wrap;
    AddressV = Wrap;
    MinFilter     = ANISOTROPIC;
    MagFilter     = ANISOTROPIC;
    MipFilter     = ANISOTROPIC;
};

sampler2D tex_nrm_0=sampler_state
{
    Texture = <m_tex_nrm_0>;
    AddressU = Wrap;
    AddressV = Wrap;
    MinFilter     = LINEAR;
    MagFilter     = LINEAR;
    MipFilter     = LINEAR;

};

sampler2D tex_spec_0=sampler_state
{
    Texture = <m_tex_spec_0>;
    AddressU = Wrap;
    AddressV = Wrap;
    MinFilter     = LINEAR;
    MagFilter     = LINEAR;
    MipFilter     = LINEAR;
};
///////////mesz 1
texture		m_tex_diff_1;
texture		m_tex_nrm_1;
texture		m_tex_spec_1;

sampler2D tex_diff_1=sampler_state
{
    Texture = <m_tex_diff_1>;
    AddressU = Wrap;
    AddressV = Wrap;
    MinFilter     = LINEAR;
    MagFilter     = LINEAR;
    MipFilter     = LINEAR;
};

sampler2D tex_nrm_1=sampler_state
{
    Texture = <m_tex_nrm_1>;
    AddressU = Wrap;
    AddressV = Wrap;
    MinFilter     = LINEAR;
    MagFilter     = LINEAR;
    MipFilter     = LINEAR;
};

sampler2D tex_spec_1=sampler_state
{
    Texture = <m_tex_spec_1>;
    AddressU = Wrap;
    AddressV = Wrap;
    MinFilter     = LINEAR;
    MagFilter     = LINEAR;
    MipFilter     = LINEAR;
    

};

//////////////////////
texture		m_texture0;
texture		m_texture1;
texture		m_texture2;
texture		m_texture3;
texture		m_RenderTexture;
texture		m_textureCube0;
texture		m_textureCube1;
texture		m_RenderTexture2;
texture		m_VolumeTexture;

sampler2D renderTex2=sampler_state
{
    Texture = <m_RenderTexture2>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;

};

sampler2D renderTex=sampler_state
{
    Texture = <m_RenderTexture>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;

};

sampler2D tex0=sampler_state
{
    Texture = <m_texture0>;
    AddressU = Wrap;
    AddressV = Wrap;
    MinFilter     = ANISOTROPIC;
    MagFilter     = ANISOTROPIC;
    MipFilter     = ANISOTROPIC;
    //MaxAnisotropy = 16;

};

sampler2D tex1=sampler_state
{
    Texture = <m_texture1>;
    MinFilter     = ANISOTROPIC;
    MagFilter     = ANISOTROPIC;
    MipFilter     = ANISOTROPIC;
    //MaxAnisotropy = 16;

};

sampler2D tex2=sampler_state
{
    Texture = <m_texture2>;
    MinFilter     = ANISOTROPIC;
    MagFilter     = ANISOTROPIC;
    MipFilter     = ANISOTROPIC;
};

sampler2D tex3=sampler_state
{
    Texture = <m_texture3>;
    MinFilter     = ANISOTROPIC;
    MagFilter     = ANISOTROPIC;
    MipFilter     = ANISOTROPIC;
};


sampler texVolume=sampler_state
{
    Texture = <m_VolumeTexture>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
};

sampler texCube=sampler_state
{
    Texture = <m_textureCube0>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
};

sampler texCube1=sampler_state
{
    Texture = <m_textureCube1>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
};
//*****************************************************************
struct PS_INPUT_ALPHATESTING
{
	float2 Texture0:			TEXCOORD0;
	float3 Normal:				TEXCOORD7;
	float3 ViewDirection:		TEXCOORD2;
	float3 LightDirection:		TEXCOORD3;
	float3 Light1Direction:		TEXCOORD4;
	float4 DofDepth:			COLOR0;
};

struct VS_OUTPUT_ALPHATESTING
{

	float4 Position:			POSITION0;
	float4 DofDepth:			COLOR0;
	float2 Texture0:			TEXCOORD0;
	float3 Normal:				TEXCOORD7;
	float3 ViewDirection:		TEXCOORD2;
	float3 LightDirection:		TEXCOORD3;
	float3 Light1Direction:		TEXCOORD4;
};

//*****************************************************************
struct VS_INPUT_BLOBS
{
   float4 Position:		POSITION;
   float3 Normal:		NORMAL0;
};

struct VS_OUTPUT_BLOBS
{
   float4 Position:		POSITION;
   float3 Normal:		TEXCOORD0;
   float3 ViewVector:	TEXCOORD1;
   float3 LightDir:		TEXCOORD2;
   float3 SpecularDir:	TEXCOORD3;
};

struct VS_INPUT 
{
	float4 Pos:			POSITION0;
	float3 Normal:		NORMAL0;
	float2 Tex:			TEXCOORD0;
	float4 Col:			COLOR0;
};

struct VS_OUTPUT 
{
	float4 Pos:				POSITION;
	float4 LightColor:		COLOR0;
	float2 Tex:				TEXCOORD0;//koordynaty textury
	float3 LightDirect:		TEXCOORD3;//pozycja swiatla
	float3 Normal:			TEXCOORD4;//normale
};

struct VS_INPUT_2
{
	float4 Position:		POSITION0;
	float4 Normal:			NORMAL0;
	float2 Texture0:		TEXCOORD0;
};
/////////////////////////////


struct VS_OUTPUT_2
{
	float4 Position:		POSITION0;
	float2 Texture0:		TEXCOORD0;
	float3 Normal:			TEXCOORD1;
	float3 ViewVector:		TEXCOORD2;
	float3 LightDir:		TEXCOORD3;
	float3 SpecularDir:		TEXCOORD4;
	float4 SpecularColor: 	COLOR0;
};
//////////////////////////////
struct VS_BUMP_INPUT 
{
   float4 Position : POSITION0;
   float2 Texcoord : TEXCOORD0;
   float3 Normal :   NORMAL0;
   float3 Binormal : BINORMAL0;
   float3 Tangent :  TANGENT0;
   int    iClusterOffset:BLENDWEIGHT;
   float4 fv4PRTWeights[NUM_PRT_WEIGHT/4]:BLENDWEIGHT1;
};


struct VS_BUMP_DOF_OUTPUT 
{
   float4 Position :        POSITION0;
   float2 Texcoord :        TEXCOORD0;
   
   float3 ViewDirection :   TEXCOORD6;
   float3 LightDirection:   TEXCOORD7;
   float3 LightDirection1:  TEXCOORD5;
   float4 LightPosition:    TEXCOORD4;   
   float4 Diffuse   :		TEXCOORD2;//PRT
   float4 DofDepth: 		COLOR0;
};

struct PS_BUMP_INPUT 
{
   float2 Texcoord :        TEXCOORD0;
   float4 Diffuse   :		TEXCOORD2;//PRT
   float4 LightPosition:    TEXCOORD4;
   float3 LightDirection1:  TEXCOORD5;
   float3 ViewDirection :   TEXCOORD6;
   float3 LightDirection:   TEXCOORD7;
   float4 DofDepth: 		COLOR0;
   
};

struct PS_INPUT
{
	float2 Texcoord :       TEXCOORD0;
	float3 Normal :			TEXCOORD1;
	float3 ViewVector:		TEXCOORD2;
	float3 LightDirection:  TEXCOORD3;
	float3 SpecularDir:		TEXCOORD4;
	float4 LightColor:		COLOR0;
   
};
//////////hdr-test

struct PS_INPUT_HDR
{
   float2 Texcoord :        TEXCOORD0;
   float3 Normal :          TEXCOORD6;
   float3 ViewVector:		TEXCOORD2;
   float3 LightDir:			TEXCOORD3;
   float3 SpecularDir:		TEXCOORD4;
   float3 CubeCoord:		TEXCOORD5;
   float4 SpecularColor: 	COLOR0;
};

struct VS_OUTPUT_HDR
{
	float4 Position:		POSITION0;
	float2 Texture0:		TEXCOORD0;
	float3 Normal:			TEXCOORD6;
	float3 ViewVector:		TEXCOORD2;
	float3 LightDir:		TEXCOORD3;
	float3 SpecularDir:		TEXCOORD4;
	float3 CubeCoord:		TEXCOORD5;
	float4 SpecularColor: 	COLOR0;
};

struct VS_MORPH_BUMP_INPUT 
{
   float4 Position : POSITION0;
   float2 Texcoord : TEXCOORD0;
   float3 Normal :   NORMAL0;
   float3 Binormal : BINORMAL0;
   float3 Tangent :  TANGENT0;
   
   float4 Position2 : POSITION1;
   float3 Normal2 :   NORMAL1;
   float3 Binormal2 : BINORMAL1;
   float3 Tangent2 :  TANGENT1;
};

/////////blur
struct VS_DOF_INPUT 
{
	float4 Pos:			POSITION;
	float2 Texcoord:	TEXCOORD0;
	float4 Col:			COLOR0;
};

struct VS_DOF_OUTPUT 
{
	float4 Pos:			POSITION;
	float2 Texcoord:	TEXCOORD0;
};

struct PS_DOF_INPUT 
{
	float2 Texcoord:	TEXCOORD0;
};

struct VS_OUTPUT_BLUR 
{
   float4 Position:		POSITION;
   float2 TexCoord:		TEXCOORD0;
};

struct VS_INPUT_BLUR 
{
   float4 Position:		POSITION;
   float2 TexCoord:		TEXCOORD0;
};

struct VS_OUTPUT_DEFAULT
{
   float4 Position:		POSITION;
   float2 TexCoord:		TEXCOORD0;
   
};

struct VS_INPUT_DEFAULT 
{
   float4 Position:		POSITION;
   float2 TexCoord:		TEXCOORD0;
};

struct VS_OUTPUT_CAUST
{
	float4 Position:		POSITION0;
	float2 Texture0:		TEXCOORD0;
	float3 Normal:			TEXCOORD6;
	float3 ViewVector:		TEXCOORD2;
	float3 LightDir:		TEXCOORD3;
	float4 SpecularColor: 	COLOR0;
};

struct PS_INPUT_CAUST
{
   float2 Texcoord :        TEXCOORD0;
   float3 Normal :          TEXCOORD6;
   float3 ViewVector:		TEXCOORD2;
   float3 LightDir:			TEXCOORD3;
   float4 SpecularColor: 	COLOR0;
};

struct VS_OUTPUT_SPRITE
{
   float4 Position:		POSITION;
   float4 Color:		COLOR0;   
};

struct VS_INPUT_SPRITE 
{
   float4 Position:		POSITION;
   float4 Color:		COLOR0;
};


struct SkyboxVS_Input
{
    float4 Pos : POSITION;
};

struct SkyboxVS_Output
{
    float4 Pos : POSITION;
    float3 Tex : TEXCOORD0;
};
struct VS_OUTPUT_REFRACTION
{
   float4 Position:		POSITION;
   float2 Texcoord:		TEXCOORD0;
   float3 Eye:			TEXCOORD1;
};

struct PS_INPUT_REFRACTION
{
   float3 Texcoord:		TEXCOORD0;
   float3 Eye:			TEXCOORD1;
};

struct PS_INPUT_HDR2
{
	float2 Texcoord:		TEXCOORD0;
	float3 ReflectPos:		TEXCOORD3;
	float3 Normal:			TEXCOORD6;
	float3 ViewVector:		TEXCOORD2;
    float4 Depth:			COLOR0;
};

struct VS_OUTPUT_HDR2
{
	float4 Position:		POSITION0;
	float2 Texcoord:		TEXCOORD0;
	float3 ReflectPos:		TEXCOORD3;
	float3 Normal:			TEXCOORD6;
	float3 ViewVector:		TEXCOORD2;
	float4 Depth:			COLOR0;
};

struct VS_OUTPUT_PRT
{
    float4 Position  :		POSITION;
    float4 Diffuse   :		TEXCOORD6;
    float2 TexCoord  :		TEXCOORD0;
    float3 Normal:			TEXCOORD7;
	float3 ViewVector:		TEXCOORD2;
	float3 LightDir:		TEXCOORD3;
	float3 SpecularDir:		TEXCOORD4;
	float3 CubeCoord:	 	TEXCOORD5;
	float4 SpecularColor: 	COLOR0;
	
//   float3 ViewDirection :   TEXCOORD7;
//   float3 LightDirection:   TEXCOORD2;

};

struct PS_INPUT_SHPRT
{
	float4 MeshParam	:		COLOR0;
	float2 TexCoord		:		TEXCOORD0;
    float4 Diffuse		:		TEXCOORD7;
	float3 ViewDirection:		TEXCOORD6;
	float3 LightDirection:		TEXCOORD5;
	float3 LightDirection1:		TEXCOORD4;
};

struct VS_OUTPUT_SHPRT
{
    float4 Position		:		POSITION;
    float4 MeshParam	:		COLOR0;
    float2 TexCoord		:		TEXCOORD0;
	float4 Diffuse		:		TEXCOORD7;
	float3 ViewDirection:		TEXCOORD6;
	float3 LightDirection:		TEXCOORD5;
	float3 LightDirection1:		TEXCOORD4;
};

struct VS_INPUT_PRT
{
    float4 Position:POSITION;
    float2 TexCoord:TEXCOORD0;
    float2 TexCoord2:TEXCOORD1;
	float3 Normal:	NORMAL0;
    float3 Binormal : BINORMAL0;
    float3 Tangent :  TANGENT0;
    int    iClusterOffset:BLENDWEIGHT;
    float4 fv4PRTWeights[NUM_PRT_WEIGHT/4]:BLENDWEIGHT1;
};

struct PS_OUTPUT_PRT
{   
    float4 RGBColor : COLOR0;
};
//****************************************************************
float ComputeDepthBlur (float fDepth)
{
   float f;
   if (fDepth < fDFocus)
   {
      f =(fDepth - fDFocus)/(fDFocus - fDNear);
   }
   else
   {
      f = (fDepth - fDFocus)/(fDFar - fDFocus);
      f = clamp (f, 0, fFarClamp);
   }
   return abs(f * 0.5f + 0.5f);
}
//****************************************************************Normalmapping
struct PS_INPUT_SHADOW
{
   float2 ShadowDepth:			TEXCOORD7;
};

struct VS_INPUT_SHADOW
{
	float4 Position:			POSITION0;
	float2 Texcoord:			TEXCOORD0;	
	float3 Normal:				TEXCOORD7;
};

struct VS_OUTPUT_SHADOW
{
	float4 Position:			POSITION0;
	float2 ShadowDepth:			TEXCOORD7;
};


struct VS_OUTPUT_POINT_SHADOW
{
	float4 Position:			POSITION0;
	float2 Texcoord:			TEXCOORD0;
	float3 LightDist:			TEXCOORD7;
};

struct PS_INPUT_POINT_SHADOW
{
	float2 Texcoord:			TEXCOORD0;
    float3 LightDist:			TEXCOORD7;
};
//*********************************************************
bool	isPRTMonochrome=false;

float4 GetPRTDiffuse( int iClusterOffset, float4 fv4PRTWeights[NUM_PRT_WEIGHT/4] )
{
    float4 vColorR = float4(0,0,0,0);
    float4 vColorG = float4(0,0,0,0);
    float4 vColorB = float4(0,0,0,0);
    
    for (int j=0; j < (NUM_PRT_WEIGHT/4); j++) 
    {
        vColorR += fv4PRTWeights[j] * fv4PRTConst[iClusterOffset+1+(NUM_PRT_WEIGHT/4)*0+j];
        vColorG += fv4PRTWeights[j] * fv4PRTConst[iClusterOffset+1+(NUM_PRT_WEIGHT/4)*1+j];
        vColorB += fv4PRTWeights[j] * fv4PRTConst[iClusterOffset+1+(NUM_PRT_WEIGHT/4)*2+j];
    }    
    float4 vDiffuse = fv4PRTConst[iClusterOffset];
    vDiffuse.r += dot(vColorR,1);
    vDiffuse.g += dot(vColorG,1);
    vDiffuse.b += dot(vColorB,1);
    if(isPRTMonochrome) vDiffuse.rgb=(vDiffuse.r+vDiffuse.g+vDiffuse.b)/3;
    return vDiffuse;
}
//********************************************************* 
VS_OUTPUT_POINT_SHADOW shadowPointVS(VS_INPUT_SHADOW In)
{
	VS_OUTPUT_POINT_SHADOW Out;
	float4 fv4Position=mul(In.Position,matProj);
	float4 fv4ObjPos=mul(In.Position,matWorld);
	float3 fv3LightDist=(fv3PointLightPosition-fv4ObjPos);
	Out.Position=fv4Position;
	Out.Texcoord=In.Texcoord;
	Out.LightDist=fv3LightDist;
	return Out;
}
//*********************************************************
float4 shadowPointPS(PS_INPUT_POINT_SHADOW In) : COLOR0
{
	float fLength=length(In.LightDist);
	float4 fv4Color=(fLength,fLength,fLength,fLength);
	float4 fvBaseColor	= tex2D(tex0,In.Texcoord);
	
	float fTest=(fvBaseColor.r+fvBaseColor.g+fvBaseColor.b)/3;
	
	if(fTest>0.55) fvBaseColor.a=0;
	if(fvBaseColor.a>0)	
	{
		if(fvBaseColor.a<2.f/256.f)	fvBaseColor.a=2.f/256.f;
		fv4Color.a=2.f/256.f;
	}
	else fv4Color.a=0;

	return fv4Color;
}
//*********************************************************
VS_OUTPUT_SHADOW shadowVS(VS_INPUT_SHADOW In)
{
	VS_OUTPUT_SHADOW Out;
	float4 fv4Position=mul(In.Position,matProj);
	float2 fv2Depth;
	fv2Depth.xy=fv4Position.zw;
	Out.Position=fv4Position;
	Out.ShadowDepth=fv2Depth;
	return Out;
}
//*********************************************************
float4 shadowPS(PS_INPUT_SHADOW In) : COLOR0
{
	float4 fv4Color=In.ShadowDepth.x/In.ShadowDepth.y;
	return fv4Color;
}
//*********************************************************
float4 showShadowDepthPS(float2 Texcoord : TEXCOORD0) : COLOR0
{
	float4 fv4Color=tex2D(tex_shadow_mapp,Texcoord);
	return fv4Color;
}
//*********************************************************
bool	isPrt=false;

VS_BUMP_DOF_OUTPUT vsBump(VS_BUMP_INPUT In)
{
   VS_BUMP_DOF_OUTPUT Out;
   float4 fv4ObjViewWorld=In.Position;
   float4 fvPosition=mul(In.Position,matProj);
   float4 fvDiffusePRT=0;
   if(isPrt) fvDiffusePRT=fv4PRTDiffColor*GetPRTDiffuse(In.iClusterOffset,In.fv4PRTWeights);//wspolczynniki prt
   Out.Diffuse=fvDiffusePRT;
   Out.Position=fvPosition;
   Out.Texcoord=In.Texcoord;
   float4 DofDepth;
   float  fDepth=ComputeDepthBlur(fvPosition.z);
   float3 fvObjectPosition = mul(In.Position,matWorld);
   float3 fvViewDirection  = normalize(-fvEyePosition+fvObjectPosition);//-fvEyePosition+fvObjectPosition;	//pozycja oka
   float3 fvLightDirection = -fvDiffusePosition+fvObjectPosition;//pozycja swiatla
   
   float3 fvNormal         = (mul(In.Normal,matWorldIT));//normalna
   float3 fvBinormal       = (mul(In.Binormal,matWorldIT));//binormalna
   float3 fvTangent        = (mul(In.Tangent,matWorldIT));//styczna
   Out.ViewDirection.x  = (dot(fvTangent,fvViewDirection));
   Out.ViewDirection.y  = (dot(fvBinormal,fvViewDirection));
   Out.ViewDirection.z  = (dot(fvNormal,fvViewDirection));
   //pierwsze swiatlo
   Out.LightDirection.x  = (dot(fvTangent,fvLightDirection));//x
   Out.LightDirection.y  = (dot(fvBinormal,fvLightDirection));//y
   Out.LightDirection.z  = (dot(fvNormal,fvLightDirection));//z
   //drugie swiatlo
   Out.LightDirection1.x  = (dot(fvTangent,fvLightDirection));//x
   Out.LightDirection1.y  = (dot(fvBinormal,fvLightDirection));//y
   Out.LightDirection1.z  = (dot(fvNormal,fvLightDirection));//z
   
   //fvLightDirection = -fvDiffuse1Position+fvObjectPosition;
   //Out.LightDirection1.x  = (dot(fvTangent,fvLightDirection));//x
   //Out.LightDirection1.y  = (dot(fvBinormal,fvLightDirection));//y
   //Out.LightDirection1.z  = (dot(fvNormal,fvLightDirection));//z

   fvLightDirection=fv3PointLightPosition-fvObjectPosition;
   float4 fv4LVect=0;
   
   fv4LVect.a=fDepth;
   Out.DofDepth=fv4LVect;
   Out.LightPosition.xyz=(fvNormal*0.00-fvLightDirection);
   Out.LightPosition.w=1;
   return Out;
}
//*********************************************************
float fPCFOffset=0.1f;
//*********************************************************
float getShadowValue(float3 fvCubeCoords)
{
   float fShadowValue=0;
   float lenSqr = length(fvCubeCoords)-fShadowOffset;
   float4 fv4Shadow=0;
   fPCFOffset=0.1f;
   fv4Shadow.r=texCUBE(texShadowCube,fvCubeCoords);
   fv4Shadow.g=texCUBE(texShadowCube,fvCubeCoords+float3(fPCFOffset,0,0));
   fv4Shadow.b=texCUBE(texShadowCube,fvCubeCoords+float3(0,-fPCFOffset,0));
   fv4Shadow.a=texCUBE(texShadowCube,fvCubeCoords+float3(fPCFOffset,-fPCFOffset,0));
   float4 fLight=0;
   fLight=(lenSqr<fv4Shadow);
   fShadowValue=dot(fLight,float4(0.25,0.25,0.25,0.25));
   if(fShadowValue<1) 
   {
 		fShadowValue*=fShadowIntensity;
		fShadowValue+=1-fShadowIntensity;
   }
   return fShadowValue;
}
bool isShadow=true;
bool isShowTexture=true;
bool isLightMap=false;
float fvTillX=1.0f;
float fvTillY=1.0f;
//*********************************************************
float4 psBlack(PS_BUMP_INPUT Input) : COLOR 
{
   float4 fColor =0;
   float4 fvDofDepth	   = Input.DofDepth;
   if(fvDofDepth.a==0) fvDofDepth.a=1.f/256.f;
   fColor*=fExposure;
   fColor.a=fvDofDepth.a;
   return fColor;
}
//*********************************************************


float4 psArrows(PS_BUMP_INPUT Input) : COLOR0
{
   float4 fvDofDepth	   = Input.DofDepth;
   float4 fvSHPRT		   = Input.Diffuse;
   fvSHPRT.gb=0;
   fvSHPRT.r*=1.4;
   float4 fvTotalLight=fvSHPRT;//
   if(fExposure<2) fvTotalLight=lerp(fvSHPRT,float4(1,1,1,1),fExposure);
   else fvTotalLight=fvSHPRT*(fExposure-2.0f);
   fvTotalLight.a=fvDofDepth.a;
   return fvTotalLight;
}
//*********************************************************
float4 psPRT(PS_BUMP_INPUT Input) : COLOR0
{
   float4 fvDofDepth	   = Input.DofDepth;
   float4 fvSHPRT		   = Input.Diffuse;
   //fvSHPRT=(fvSHPRT.r+fvSHPRT.g+fvSHPRT.b)/3;
   float4 fvTotalLight=fvSHPRT*fExposure;
   if(fvDofDepth.a==0) fvDofDepth.a=1.f/256.f;
   fvTotalLight.a=fvDofDepth.a;
   return fvTotalLight;
}
//*********************************************************
float4 psBump(PS_BUMP_INPUT Input) : COLOR0
{
   float4 fvDofDepth	   = Input.DofDepth;
   float3 fvViewDirection  = normalize(Input.ViewDirection);
   float3 fvLightDirection = normalize(Input.LightDirection);
   float4 fvBaseColor      = tex2D(tex0,Input.Texcoord*float2(fvTillX,fvTillY));
   //float4 fv4LightMap      = tex2D(tex3,Input.Texcoord*float2(fvTillX,fvTillY));
   float3 fvNormal         = normalize((tex2D(tex1,Input.Texcoord*float2(fvTillX,fvTillY)).xyz*4.0f)-2.0f);
   float4 fvSpecularMap	   = tex2D(tex2,Input.Texcoord);
   float  fNDotL           = 0;
   float3 fvReflection     = 0;
   float  fRDotV           = 0;
   float4 fvTotalDiffuse   = 0.15;
   float4 fvTotalSpecular  = 0;
   float4 fv4LightPos	   = Input.LightPosition;//pozycja swiatla
   float  fShadowValue     = 1;
   float4 fvSHPRT		   = Input.Diffuse;//shprt
   
   
   //fvBaseColor=1;
   //if(isLightMap) fvBaseColor*=fv4LightMap;//lightmapy
   
   fvSpecularColor=fvDiffuseColor;
   fNDotL=dot(fvNormal,fvLightDirection); 
   if(fNDotL>=0) fvTotalDiffuse+=fvDiffuseColor*fNDotL;//skladnik koloru pierwszego
   fvReflection=normalize(((2.0f*(fvNormal))*(fNDotL))-fvLightDirection); 
   fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
   
   //if(fRDotV<0) fRDotV=0;
   fvTotalSpecular+=fvSpecularColor*pow(fRDotV,fSpecularPower);//fSpecular;
   //////////////////////
   //fvSpecularColor=fvDiffuse1Color;
   //fvLightDirection = normalize(Input.LightDirection1);
   //fNDotL=dot(fvNormal,fvLightDirection); 
   //if(fNDotL>=0) fvTotalDiffuse+=fvDiffuse1Color*fNDotL;
   
   //fvReflection=normalize(((2.0f*fvNormal)*(fNDotL))-fvLightDirection); 
   //fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
   //fvTotalSpecular+=fvSpecularColor*pow(fRDotV,fSpecularPower);
   
   //if(isPrt)
   {
		//float _bw=(fvSHPRT.r+fvSHPRT.g+fvSHPRT.b)/3;
		//fvSHPRT=_bw;
		//fvSHPRT+=fvBaseColor;
		fvTotalDiffuse+=fvSHPRT;
		
   }
   
   float4 fvTotalLight=0;
   
   if(!isPrt) fvTotalLight=(fvTotalDiffuse*fvBaseColor+fvTotalSpecular*fvSpecularMap)*fShadowValue*fExposure;
   else 
   {
		if(isShowTexture) 
		{
			//fvTotalLight=(fvTotalDiffuse*fvBaseColor+fvTotalSpecular*fvSpecularMap)*fShadowValue*fExposure;
			if(fExposure<2)	fvTotalLight=lerp(fvTotalDiffuse*fvBaseColor+fvTotalSpecular*fvSpecularMap,float4(1,1,1,1),fExposure);
			else fvTotalLight=(fvTotalDiffuse*fvBaseColor+fvTotalSpecular*fvSpecularMap)*(fExposure-2.0f);
				
		}
		else fvTotalLight=fvSHPRT*fShadowValue*fExposure;
   }
	if(fvDofDepth.a==0) fvDofDepth.a=1.f/256.f;
   fvTotalLight.a=fvDofDepth.a;
   return fvTotalLight;
}
//*********************************************************Reflect
float3 fv3CameraPosition=0;

VS_BUMP_DOF_OUTPUT vsReflect(VS_BUMP_INPUT In)
{
   VS_BUMP_DOF_OUTPUT Out;
   float4 fv4ObjViewWorld=In.Position;
   float4 fv4LightPosition=mul(fv4ObjViewWorld,matViewToLightProj);
   float4 fvPosition=mul(In.Position,matProj);
   float4 fvDiffusePRT=0;
   if(isPrt) fvDiffusePRT=fv4PRTDiffColor*GetPRTDiffuse(In.iClusterOffset,In.fv4PRTWeights);//wspolczynniki prt
   Out.Diffuse=fvDiffusePRT;
   Out.Position=fvPosition;
   Out.Texcoord=In.Texcoord;
   float4 DofDepth;
   float  fDepth=ComputeDepthBlur(fvPosition.z);
   float3 fvObjectPosition = mul(In.Position,matWorld);
   float3 fvViewDirection  = normalize(-fvEyePosition+fvObjectPosition);//-fvEyePosition+fvObjectPosition;	//pozycja oka
   float3 fvLightDirection = -fvDiffusePosition+fvObjectPosition;//pozycja swiatla
   
   float3 fvNormal         = (mul(In.Normal,matWorldIT));//normalna
   float3 fvBinormal       = (mul(In.Binormal,matWorldIT));//binormalna
   float3 fvTangent        = (mul(In.Tangent,matWorldIT));//styczna
   Out.ViewDirection.x  = (dot(fvTangent,fvViewDirection));
   Out.ViewDirection.y  = (dot(fvBinormal,fvViewDirection));
   Out.ViewDirection.z  = (dot(fvNormal,fvViewDirection));
   //pierwsze swiatlo
   Out.LightDirection.x  = (dot(fvTangent,fvLightDirection));//x
   Out.LightDirection.y  = (dot(fvBinormal,fvLightDirection));//y
   Out.LightDirection.z  = (dot(fvNormal,fvLightDirection));//z
   //drugie swiatlo
   fvLightDirection = -fvDiffuse1Position+fvObjectPosition;
   Out.LightDirection1.x  = (dot(fvTangent,fvLightDirection));//x
   Out.LightDirection1.y  = (dot(fvBinormal,fvLightDirection));//y
   Out.LightDirection1.z  = (dot(fvNormal,fvLightDirection));//z
   //dodac oblicznie glebokosci dla dofa
   fvLightDirection=-fv3PointLightPosition+fvObjectPosition;
   fv4LightPosition.xyz=fvLightDirection;
   float4 fv4LVect=0;
   fv4LVect.xyz=-fv3CameraPosition+fvObjectPosition;//fvNormal.xyz;
   fv4LVect.a=fDepth;
   Out.DofDepth=fv4LVect;
   Out.LightPosition.xyz=fv4LightPosition.xyz;
   Out.LightPosition.w=1;
   return Out;
}

float4 psReflect(PS_BUMP_INPUT Input) : COLOR0
{
   float4 fvDofDepth	   = Input.DofDepth;
   float3 fvViewDirection  = normalize(Input.ViewDirection);
   float3 fvLightDirection = normalize(Input.LightDirection);
   float4 fvBaseColor      = tex2D(tex0,Input.Texcoord*10);
   float3 fvNormal         = normalize((tex2D(tex1,Input.Texcoord*10).xyz*4.0f)-2.0f);
   float4 fvSpecularMap	   = tex2D(tex2,Input.Texcoord*10);
   float  fNDotL           = 0;
   float3 fvReflection     = 0;
   float  fRDotV           = 0;
   float4 fvTotalDiffuse   = 0.15;
   float4 fvTotalSpecular  = 0;
   float4 fv4LightPos	   = Input.LightPosition;//pozycja swiatla
   float  fShadowValue     = 1;
   float4 fvSHPRT		   = Input.Diffuse;//shprt
   
   fvSpecularColor=fvDiffuseColor;
   fNDotL=dot(fvNormal,fvLightDirection); 
   if(fNDotL>=0) fvTotalDiffuse+=fvDiffuseColor*fNDotL;//skladnik koloru pierwszego
	   
   //if(isShadow)	fShadowValue=getShadowValue(fv4LightPos.xyz);
   fvReflection=normalize(((2.0f*(fvNormal))*(fNDotL))-fvLightDirection); 
   fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
   if(fRDotV<0) fRDotV=0;
   //fSpecular=fvSpecularColor*pow(fRDotV,fSpecularPower);
   //if(fSpecular<0) fSpecular=100;
   fvTotalSpecular+=fvSpecularColor*pow(fRDotV,fSpecularPower);//fSpecular;
   //////////////////////
   fvSpecularColor=fvDiffuse1Color;
   fvLightDirection = normalize(Input.LightDirection1);
   fNDotL=dot(fvNormal,fvLightDirection); 
   if(fNDotL>=0) fvTotalDiffuse+=fvDiffuse1Color*fNDotL;
   
   fvReflection=normalize(((2.0f*fvNormal)*(fNDotL))-fvLightDirection); 
   fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
   if(fRDotV<0) fRDotV=0; 
   fvTotalSpecular+=fvSpecularColor*pow(fRDotV,fSpecularPower);
   
   if(isPrt)
   {
		fvSHPRT.rgb=(fvSHPRT.r+fvSHPRT.g+fvSHPRT.b)/3;
		float4 fvNMPRT=fvSHPRT;
		fvNMPRT.r=dot(fvSHPRT.r,fvNormal);
		fvNMPRT.g=dot(fvSHPRT.g,fvNormal);
		fvNMPRT.b=dot(fvSHPRT.b,fvNormal);
		fvSHPRT=fvNMPRT;
		fColorScaler=0.5f;
		fvTotalDiffuse*=fvSHPRT;//=lerp(fvSHPRT,fvTotalDiffuse,fColorScaler);
   }
   
   fvReflection=texCUBE(texCube,fvDofDepth.xyz);
   
   float4 fvTotalLight=(fvTotalDiffuse*fvBaseColor+fvTotalSpecular*fvSpecularMap)*fShadowValue*fExposure;
   
   //fvTotalLight.xyz=lerp(fvTotalLight,fvReflection,0.7);
   
   //if(isPrt) fvTotalLight=fvSHPRT;
   fvTotalLight.xyz=fvReflection.xyz;
   fvTotalLight.a=fvDofDepth.a;
   return fvTotalLight;
}
//****************************************************************Alphatesting
VS_OUTPUT_ALPHATESTING vsAlphatesting( VS_INPUT Input)
{
	VS_OUTPUT_ALPHATESTING Out;
	float3 fvObjectPosition   = mul(Input.Pos,matWorld);
	float3 fvLightDirection   = -fvDiffusePosition + fvObjectPosition;
	float3 fvLight1Direction  = -fvDiffuse1Position + fvObjectPosition;
	float3 fvNormal           = mul(Input.Normal,matWorldIT);
	float4 fvPosition		  = mul(Input.Pos,matProj);
	float4 fvDofDepth=0;
	Out.Position=fvPosition;
	Out.Texture0=Input.Tex;
	Out.Normal=fvNormal;
	Out.ViewDirection=-fv3PointLightPosition+fvObjectPosition;//wektor swiatla
	Out.LightDirection=fvLightDirection;
	Out.Light1Direction=fvLight1Direction;
	float fDepth=ComputeDepthBlur(fvPosition.z);
	fvDofDepth.a=fDepth;
    Out.DofDepth=fvDofDepth;
    return Out;
}
//*********************************************************
float4 psAlphatesting( PS_INPUT_ALPHATESTING Input ) : COLOR0
{
	float3 fvNormal				= normalize(Input.Normal);
	float3 fvLightDirection		= normalize(Input.LightDirection);
	float  fNDotL				= abs(dot(fvNormal,fvLightDirection));
	float4 fvDofDepth			= Input.DofDepth;
	float4 fvBaseColor			= tex2D(tex0,Input.Texture0);
	float4 fvTotalDiffuse		= 0;
	float4 fShadowValue			= 1;
	float4 fv4LightPos			= 0;
	fv4LightPos.xyz=Input.ViewDirection;
	fv4LightPos.w=0;
	///////////
	if(isShadow) fShadowValue=getShadowValue(fv4LightPos);
	if(fNDotL>0) fvTotalDiffuse+=(fNDotL*fvDiffuseColor);
	fvLightDirection = normalize(Input.Light1Direction);
	fNDotL = abs(dot(fvNormal,fvLightDirection));
	if(fNDotL>0) fvTotalDiffuse+=fNDotL*fvDiffuse1Color;
	float4 color;
	color=fvTotalDiffuse*fvBaseColor*fShadowValue;
	color.xyz*=fExposure;
	if(fvBaseColor.a>0.8)	
	{
		if(fvDofDepth.a<2.f/256.f)	
		fvDofDepth.a=2.f/256.f;
		
	}
	else fvDofDepth.a=0;
	color.a=fvDofDepth.a;
	return color;
}
//*********************************************************

VS_OUTPUT_DEFAULT vsDefault(VS_INPUT_DEFAULT In)
{
	VS_OUTPUT_DEFAULT Out;
	Out.Position=mul(In.Position,matProj);
	Out.TexCoord=In.TexCoord;
	return Out;
}
//*********************************************************
float4 psMorph(float3 TexCoord: TEXCOORD0) : COLOR 
{
   float4 fColor =1;// tex2D(tex0,TexCoord);
   //fColor.a=0;
   return fColor;
}
//*********************************************************
float4 psEarth(float3 TexCoord: TEXCOORD0) : COLOR 
{
   float4 fColor = tex2D(tex0,TexCoord);
   //fColor.a=0;
   
   return (fColor*3)*(fExposure-2);
}
//*********************************************************
float4 psParticle(float3 TexCoord: TEXCOORD0) : COLOR 
{
   float4 fColor = tex2D(tex0,TexCoord);
   float _mask=(fColor.r+fColor.g+fColor.b)/3;
   if(_mask>0.2) fColor.a=0.5f; 
   else fColor.a=0;
   
   
   return fColor*fExposure;
}
//*********************************************************
float4 psDefault(float3 TexCoord: TEXCOORD0) : COLOR 
{
   float4 fColor = tex2D(tex0,TexCoord);
   //fColor.a=0;
   return fColor*fExposure;
}
//*********************************************************
float4 psAnim(float3 TexCoord: TEXCOORD0) : COLOR 
{
   float4 fColor = tex2D(tex0,TexCoord);
   fColor.a=0;
   return fColor*fExposure;
}
//*********************************************************
SkyboxVS_Output SkyboxVS( SkyboxVS_Input Input )
{
    SkyboxVS_Output Output;
    Output.Pos = Input.Pos;
    Output.Tex = normalize( mul(Input.Pos,matInvProj));
    return Output;
}
//*********************************************************
float4 SkyboxPS( SkyboxVS_Output Input ) : COLOR
{
    float4 color = texCUBE(texCube,Input.Tex);
    float4 ret=0;
    if(fExposure<2)
    {
		ret=lerp(color,float4(1,1,1,1),fExposure);
	}
	else
	{
		ret=color*(fExposure-2.0f);
	}
    ret.a=1;
    return ret;
}
//*********************************************************
float4 RenderBufferPS(float2 TexCoord: TEXCOORD0) : COLOR
{
    float4 color = tex2D(renderTex,TexCoord);
    return color;
}
//*********************************************************
float4 GBlurHPS( float2 Tex : TEXCOORD0 ) : COLOR0
{
    float4 Color = 0;
    float2 fOffset=0;
    for (int i = 0; i < fBlurSize; i++)
    {   
		fOffset.x=(-5+i)/fScreenWidth;
		Color+=tex2D(renderTex,Tex+fOffset)*BlurWeights[i];        
    }
    return Color*fBloomScale;
}
//*********************************************************
float4 GBlurVPS( float2 Tex : TEXCOORD0 ) : COLOR0
{
    float4 Color = 0;
    float2 fOffset=0;
    for (int i = 0; i < fBlurSize; i++)
    {    
	    fOffset.y=(-5+i)/fScreenHeight;  
	    Color+=tex2D( renderTex, Tex+ fOffset ) * BlurWeights[i];        
    }
    return Color*fBloomScale;
}
//*********************************************************
float4 downPS( float2 Tex : TEXCOORD0 ) : COLOR0
{
	float4 fColor=0;
	fColor=tex2D( renderTex, Tex );
    return fColor;
}
//*********************************************************
float4 CopyRTPS( float2 Tex : TEXCOORD0 ) : COLOR0
{
    return tex2D( renderTex, Tex );
}
//*********************************************************
VS_OUTPUT_DEFAULT vsPost(VS_INPUT_DEFAULT In)
{
	VS_OUTPUT_DEFAULT Out;
	float4 vPos=In.Position;
	vPos.xy = sign(vPos.xy)*1/fDiv;
	vPos.y*=-1;
	if(vPos.x<0) vPos.x=-1.f;
	else vPos.x=-1.f+2.f/fDiv;
	if(vPos.y>0) vPos.y=1.f;
	else vPos.y=1.f-2.f/fDiv;
	vPos.z=0;
	vPos.w=1;
	Out.Position=vPos;
	Out.TexCoord=In.TexCoord;
	return Out;
}
//*********************************************************
VS_OUTPUT_DEFAULT vsBuff(VS_INPUT_DEFAULT In)
{
	VS_OUTPUT_DEFAULT Out;
	float4 vPos=In.Position;
	vPos.xy = sign(vPos.xy);
	vPos.y*=-1;
	if(vPos.x<0) vPos.x-=1/fScreenWidth;
	if(vPos.y>0) vPos.y+=1/fScreenHeight;
	vPos.z=0;
	vPos.w=1;
	Out.Position=vPos;
	Out.TexCoord=In.TexCoord;
	return Out;
}
//*********************************************************
bool	isBitmap=false;
bool	isMask=false;
bool	isBack=false;
bool	isSecondMask=false;

float	fBitmapTransparency=0.5f;

float4 DofPS( float2 Texcoord : TEXCOORD0 ) : COLOR0
{
	float4 color= tex2D(tex0,Texcoord);
	float4 color2= tex2D(renderTex,Texcoord);
	float4 colorMask= tex2D(tex_diff_0,Texcoord);
	
	float depth=color.a*fBlurFactor;
	if(depth>1.0f) 	depth=1.0f;
	color=lerp(color,color2,depth);
	
	if(isToneMapping)
	{
		color*=(fToneMappingGray / ( fToneMappingLuminace + 0.001f ));
		color*=(1.f+(color/(fToneMappingWhiteCutoff*fToneMappingWhiteCutoff)));
		color/=(1.f+color);
    }
    
	if(isDofTest)
	{
		color.r=depth;
		color.g=depth;
		color.b=depth;
	}

	if(isBack)
	{
		float4 colorDolar=tex2D(tex_nrm_0,Texcoord);
		colorMask*=fExposure;
		if(color.a==0) color=colorMask;
		
		if(colorDolar.a!=0 && isSecondMask) color=colorMask;
	}
	
	else if(isMask)
	{
		//color=lerp(color,colorMask,colorMask.a);
	
		if(colorMask.r<0.7f)
		{
			float4 colorM=0;
			if(fExposure>0.4f) 
			{
				colorM.r=(1-colorMask.r);
				colorM*=(fExposure-0.4f);
			}
			color=lerp(color,colorM,0.7f-colorMask);
		}
		
	}
	
	else if(isBitmap)
	{
		float4 color3= tex2D(renderTex2,Texcoord);
		color=color3;
	}
	
	return color;
}
//*********************************************************
float4 BrightPassFilter(float2 Texcoord:TEXCOORD0):COLOR0
{
	float3 color2= tex2D(renderTex,Texcoord);
		color2*=fMiddleGray/(fLuminance+0.001f);
		color2*=(1.0f+(color2/(fWhiteCutoff*fWhiteCutoff)));
		color2-=5.0f;
		color2=max(color2,0.0f);
		color2/=(10.0f+color2);
	return float4(color2,1.0f);
}
float fPostNoise=3.f;
float fPostTime=0.f;
bool isPostFlip=false;
bool isOnlyBlur=false;
//*********************************************************
float4 BloomPS(float2 Texcoord:TEXCOORD0):COLOR0
{
	float2 fCoord=Texcoord;

	int t=(int)(fCoord.y*fScreenHeight);
	int g=t/2;
	g*=2;
	t-=g;
	if(t==0) fCoord.x+=fPostNoise/fScreenWidth;
	
	float4 color=tex2D(tex0,fCoord);
	float _ns=color.r*fPostNoise;
	float ttt=0;
	ttt=round(_ns);
	if(ttt>0) color.r=ttt;
	float4 colorMask= tex2D(tex_diff_0,Texcoord);
	//color+=tex2D(renderTex,fCoord);

	if(!isOnlyBlur)	color+=tex2D(renderTex,fCoord);
	else color=tex2D(renderTex,fCoord);
	
	if(isToneMapping)
	{
		color*=(fToneMappingGray / ( fToneMappingLuminace + 0.001f ));
		color*=(1.f+(color/(fToneMappingWhiteCutoff*fToneMappingWhiteCutoff)));
		color/=(1.f+color);
    }

	
   	if(isBitmap)
	{
		float4 color3= tex2D(renderTex2,Texcoord);
		if(color3.a>0.9f)
		{
			float cl=(color3.r+color3.g+color3.b)/3;
			color=lerp(color,color3,fBitmapTransparency);//color+color3*fBitmapTransparency;
		}
	}
	if(isMask)
	{
		color=lerp(color,colorMask,colorMask.a);
	}
	return color;
}
//*********************************************************
VS_OUTPUT_SHPRT PRTDiffuseVS(VS_INPUT_PRT Input)                        
{
    VS_OUTPUT_SHPRT Output;
    
    float4 fvPosition=mul(Input.Position,matProj);
    float  fDepth=ComputeDepthBlur(fvPosition.z);
	float3 fvObjectPosition=mul(Input.Position,matWorld);
	float3 fvLightDirection=fvDiffusePosition-fvObjectPosition;
	float3 fvNormal=mul(-Input.Normal,matWorld);//musze odwrocic normalne bo mam odwrotnie podpiete do shprt
    float3 fvBinormal=mul(Input.Binormal,matWorld);//binormalna
    float3 fvTangent=mul(Input.Tangent,matWorld);//styczna
    float3 fvViewDirection=-fvEyePosition+fvObjectPosition;
	///////wysylam dane 
    Output.Position=fvPosition;
    Output.Diffuse=fv4PRTDiffColor*GetPRTDiffuse(Input.iClusterOffset,Input.fv4PRTWeights);
    Output.TexCoord=Input.TexCoord;
	Output.ViewDirection.x  = dot(fvTangent,fvViewDirection);
	Output.ViewDirection.y  = dot(fvBinormal,fvViewDirection);
	Output.ViewDirection.z  = dot(fvNormal,fvViewDirection);
    //pierwsze swiatlo
    Output.LightDirection.x  = dot(fvTangent,fvLightDirection);//x
    Output.LightDirection.y  = dot(fvBinormal,fvLightDirection);//y
    Output.LightDirection.z  = dot(fvNormal,fvLightDirection);//z
    fvLightDirection = fvDiffuse1Position-fvObjectPosition;
    Output.LightDirection1.x  = dot(fvTangent,fvLightDirection);//x
    Output.LightDirection1.y  = dot(fvBinormal,fvLightDirection);//y
    Output.LightDirection1.z  = dot(fvNormal,fvLightDirection);//z
    //dodac glebokosc dla dofa
    float2 fTmp=Input.TexCoord2;
    float iMeshID=fTmp.x;//*10;
    float4 fMeshParam=0;
    
    fMeshParam.x=fTmp;
    fMeshParam.a=fDepth;
	Output.MeshParam=fMeshParam;
	
    return Output;
}
//*********************************************************

//*************OBSZAR ROBOCZY START
struct VS_OUTPUT_CLOUDS
{
   float4 Position:		POSITION;
   float2 TexCoord:		TEXCOORD0;
   
};

struct VS_INPUT_CLOUDS
{
   float4 Position:		POSITION;
   float2 TexCoord:		TEXCOORD0;
};

float		fCloudsTime=0.7;
float4x4	matInvCamRot;				//odwrotna macierz rotacji kamery

VS_OUTPUT_CLOUDS vsClouds(VS_INPUT_CLOUDS In)
{
	VS_OUTPUT_CLOUDS Out;
	float4 fv4Position=mul(In.Position,matProj);//=In.Position;
	float depth=ComputeDepthBlur(fv4Position.z);
	//fv4Position=mul(fv4Position,matInvCamRot);
	Out.Position=fv4Position;
	float3 fv3Texcoord;
	fv3Texcoord.xy=In.TexCoord;
	fv3Texcoord.z=depth;
	Out.TexCoord=In.TexCoord;
	return Out;
}

float fCloudAlphaTest=0;
float fCloudAlpha=0.3;

float4 psClouds(float3 TexCoord: TEXCOORD0) : COLOR 
{
	float3 fv3TexCoord=0;
	float4 fv4Color=tex2D(tex0,TexCoord);
	/*
	fv3TexCoord.xy=TexCoord*0.3;
	fv3TexCoord.z=fCloudsTime*5;
	float4 fv4Noise=tex3D(texVolume,fv3TexCoord);
	if(fv4Color.r>fCloudAlphaTest)//fCloudsTime)
	{
		fv4Color.a=fCloudAlpha;
	} else fv4Color.a=0;
	*/
	return fv4Color;//*fExposure;
}


/////////////odbicie
VS_OUTPUT_HDR2 hdr2VS( VS_INPUT Input)
{
	VS_OUTPUT_HDR2 Out;
	float4 Pos=Input.Pos;
	Pos.xz*=80;
	float3 fvObjectPosition=mul(Pos,matWorld);
	float4 fvPosition=mul(Pos,matProj);
	float depth=ComputeDepthBlur(fvPosition.z);
	Out.Position=fvPosition;
	Pos.xz/=2;
	Out.ReflectPos=Pos;
	float3 fv3Normal=Input.Normal;
	Out.Normal=fv3Normal;
	Out.Texcoord=Input.Tex;
	Out.ViewVector=fvObjectPosition;
	float4 fvDepth=0;
	fvDepth.a=depth;
	Out.Depth=fvDepth;
	return Out;
}

float4 hdr2PS( PS_INPUT_HDR2 Input ) : COLOR0
{
	float3 pos=Input.ReflectPos;
	pos.x+=fTime*0.13f;
	pos.z+=fTime*0.02f;
	pos.y+=fTime*0.095f;
	float4 fvNoise=tex3D(texVolume,pos);
	float3 bump =2*fvNoise-1;
	bump.xz *= 0.15;
    bump.y = 0.8 * abs(bump.y) + 0.2;
    bump = normalize(Input.Normal + bump*0.6);
    float3 reflVec = reflect(Input.ViewVector, bump);
    reflVec.y*=-1;
    float4 refl = texCUBE(texCube, reflVec);
    refl.a=Input.Depth.a;
	float4 ret=refl*fExposure;
	return ret;
}

technique RenderClouds
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsClouds();
	    PixelShader  = compile ps_2_0 psClouds();
	}
}

//*************OBSZAR ROBOCZY END
technique RenderShowShadowDepth
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsBuff();
	    PixelShader  = compile ps_2_0 showShadowDepthPS();
	}
}
//**********************************************************************
technique RenderCubeShadow
{
	pass P0
	{
		VertexShader = compile vs_2_0 shadowPointVS();
	    PixelShader  = compile ps_2_0 shadowPointPS();
	}
}
//**********************************************************************
technique RenderShadow
{
	pass P0
	{
		VertexShader = compile vs_2_0 shadowVS();
	    PixelShader  = compile ps_2_0 shadowPS();
	}
}
//**********************************************************************
technique DofProcess
{
    pass p0
    {
		VertexShader = compile vs_2_0 vsBuff();
        PixelShader = compile ps_2_0 DofPS();
        ZEnable = false;
    }
}
technique BrightFilter
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsPost();
        PixelShader = compile ps_2_0 BrightPassFilter();
        ZEnable = false;
    }
}

technique RenderBloom
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsBuff();
        PixelShader = compile ps_2_0 BloomPS();
        ZEnable = false;
    }
}

technique DownFilter
{
    pass p0
    {
        VertexShader = null;
        PixelShader = compile ps_2_0 downPS();
        ZEnable = false;
    }
}

technique UpFilter
{
    pass p0
    {
        VertexShader = null;
        PixelShader = compile ps_2_0 CopyRTPS();
        ZEnable = false;
    }
}

technique GBlurV
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsPost();
        PixelShader = compile ps_2_0  GBlurVPS();
        ZEnable = false;
    }
}

technique GBlurH
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsPost();
        PixelShader = compile ps_2_0  GBlurHPS();
        ZEnable = false;
    }
}

technique RenderBuffer
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsPost();
        PixelShader = compile ps_2_0  RenderBufferPS();
        ZEnable = false;
    }
}

technique RenderUpBuffer
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsBuff();
        PixelShader = compile ps_2_0  RenderBufferPS();
        ZEnable = false;
    }
}

technique Skybox
{
    pass p0
    {
        VertexShader = compile vs_2_0 SkyboxVS();
        PixelShader = compile ps_2_0 SkyboxPS();
    }
}

technique RenderModph
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsDefault();
	    PixelShader  = compile ps_2_0 psMorph();
	}
}
//psEarth
technique Render
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsDefault();
	    PixelShader  = compile ps_2_0 psDefault();
	}
}

technique RenderEarth
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsDefault();
	    PixelShader  = compile ps_2_0 psEarth();
	}
}

technique RenderAnim
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsDefault();
	    PixelShader  = compile ps_2_0 psAnim();
	}
}

/////////////////////
technique RenderReflect
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsReflect();
	    PixelShader  = compile ps_2_0 psReflect();
	}
}

technique RenderBlack
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsBump();
	    PixelShader  = compile ps_2_0 psBlack();
	}
}

technique RenderPrt
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsBump();
	    PixelShader  = compile ps_2_0 psPRT();
	}
}


technique RenderArrows
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsBump();
	    PixelShader  = compile ps_2_0 psArrows();
	}
}

technique RenderBump
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsBump();
	    PixelShader  = compile ps_2_0 psBump();
	}
}

technique RenderReflex
{
	pass P0
	{
		VertexShader = compile vs_2_0 hdr2VS();
	    PixelShader  = compile ps_2_0 hdr2PS();
	}
}

technique RenderAlphaTesting
{
	pass P0
	{
		VertexShader = compile vs_1_1 vsAlphatesting();
		PixelShader  = compile ps_2_0 psAlphatesting();
	}
}

technique RenderParticle
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsDefault();
	    PixelShader  = compile ps_2_0 psParticle();
	}
}

